<?php
//============================================================+
// File name   : example_009.php
// Begin       : 2008-03-04
// Last Update : 2013-05-14
//
// Description : Example 009 for TCPDF class
//               Test Image
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Test Image
 * @author Nicola Asuni
 * @since 2008-03-04
 */

// Include the main TCPDF library (search for installation path).
require_once('tcpdf_include.php');
require('/home/davidkelly/public_html/script/dbts.php');
$id=$_GET['id'];


$conn = new mysqli($servername, $username, $password, $dbname); 

if ($conn->connect_error) {
  trigger_error('Database connection failed: '  . $conn->connect_error, E_USER_ERROR);
}
$table='TestStation1_Tests_Data';

$sql= "SELECT * FROM $table where testid= $id";
//echo "/* console.log('$sql'); */";
$result = $conn->query($sql);
$row_cnt=mysqli_num_rows($result);
$row_cnt =$row_cnt/1000;
$row_offset = Floor($row_cnt);
$arr=array();
$encode=array();
$columns=array();
$columns = explode(",",$points);
$point_count = count($columns);
$rs=$conn->query($sql);
$i=0;
$row=array();
$row = $rs->fetch_array(MYSQLI_ASSOC);

 $devtype= $row['devtype'];

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Burkert Fluid Controls');
$pdf->SetTitle(' sdg'.$devtype.'');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' Device: '.$devtype.' Test ID#: '.$id, PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

// set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

// set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

// set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

// set some language-dependent strings (optional)
if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
	require_once(dirname(__FILE__).'/lang/eng.php');
	$pdf->setLanguageArray($l);
}

// ---------------------------------------------------------

// set font
$pdf->SetFont('dejavusans', '', 10);

// add a page
$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);



//$pdf->Image("http://thecloudatburkert.com/script/ml_img.php?data=002590E2D3C5_log, $devtype,$id,,300",'100','50','300','150');
$html='
<table>
<tr>
<td><b>Production Order: </b> </td>
<td>'.$row['productionorder'].'</td>
<td><b>Device ID:</b> </td>
<td>'.$row['devid'].'</td>

</tr><tr>
<td><b>Serial Number: </b> </td>
<td>'.$row['serialnumber'].'</td>
<td><b>Device Type: </b> </td>
<td> '.$row['devtype'].'</td>
</tr>
<tr>
<td colspan="4">


</td>
</tr>
</table>
<img src="http://thecloudatburkert.com/script/ml_img.php?data=002590E2D3C5_log,'.$devtype.','.$id.',,1000" alt = "Teststation", width="1000", height="500">
';
$pdf->writeHTML($html, true, false, true, false, '');














// reset pointer to the last page
$pdf->lastPage();



// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
// Print a table

// add a page
//$pdf->AddPage();

// ---------------------------------------------------------

//Close and output PDF document
$pdf->Output('teststat.pdf', 'I');



?>